<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Product extends Model 
{

    protected $table = 'products';
    public $timestamps = true;

    public function options()
    {
        return $this->hasMany('App\Models\ProductOption');
    }

    public function images()
    {
        return $this->hasMany('App\Models\ProductsImage');
    }

    public function pricing()
    {
        return $this->hasOne('App\Models\ProductsPrice');
    }

    public function priceTiers()
    {
        return $this->hasOne('App\Models\ProductsPriceTier');
    }

    public function categories()
    {
        return $this->belongsToMany('App\Models\Category');
    }

}